<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Ui\DataProvider\Product\Form\Modifier;

use Amasty\RecurringPayments\Api\Data\ProductRecurringAttributesInterface;
use Amasty\RecurringPayments\Model\Product\Source\AvailableSubscription;
use Magento\Backend\Model\Url;
use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AbstractModifier;
use Magento\Eav\Model\Entity\Attribute\Source\Boolean;
use Magento\Framework\Stdlib\ArrayManager;

class SubscriptionSettings extends AbstractModifier
{
    /**
     * @var ArrayManager
     */
    private $arrayManager;

    /**
     * @var Url
     */
    private $url;

    public function __construct(
        ArrayManager $arrayManager,
        Url $url
    ) {
        $this->arrayManager = $arrayManager;
        $this->url = $url;
    }

    /**
     * @param array $meta
     * @return array
     */
    public function modifyMeta(array $meta)
    {
        $meta = $this->addDependsToFields($meta);
        $meta = $this->addDefaultValue($meta);

        return $meta;
    }

    /**
     * @param array $meta
     * @return array
     */
    private function addDependsToFields(array $meta)
    {
        $globalSetting = '${$.ns}.${$.ns}.subscription-settings.'
            . self::CONTAINER_PREFIX
            . ProductRecurringAttributesInterface::RECURRING_ENABLE
            . '.' . ProductRecurringAttributesInterface::RECURRING_ENABLE;

        $meta = $this->arrayManager->merge(
            $this->arrayManager->findPath(
                ProductRecurringAttributesInterface::RECURRING_ENABLE,
                $meta,
                null,
                'children'
            ) . static::META_CONFIG_PATH,
            $meta,
            [
                'component' => 'Amasty_RecurringPayments/js/form/element/available-subscription',
                'template' => 'Amasty_RecurringPayments/ui/form/field',
                'notice' => __(
                    "Go to <a href='%1' target='_blank'>Stores > Configuration</a> to check other subscription "
                    . "settings.",
                    $this->url->getUrl('adminhtml/system_config/edit/section/amasty_recurring_payments')
                ),
                'listens' => [
                    $globalSetting . ':value' => 'onChange'
                ],
                'imports' => [
                    'allowed' => AvailableSubscription::CUSTOM_SETTING,
                    'fields' => '${$.ns}.${$.ns}.subscription-settings',
                    '__disableTmpl' => ['fields' => false],
                ]
            ]
        );

        $meta = $this->arrayManager->merge(
            $this->arrayManager->findPath(
                ProductRecurringAttributesInterface::PLANS,
                $meta,
                null,
                'children'
            ) . static::META_CONFIG_PATH,
            $meta,
            [
                'template' => 'Amasty_RecurringPayments/ui/form/field',
                'notice' => __(
                    "Select one or multiple plans your customers would be able to choose from when subscribing"
                    . " to the product. If you need to add more plans or modify existing ones, please visit"
                    . " <a href='%1' target='_blank'>Sales > Amasty Subscriptions > Subscription Plans</a>.",
                    $this->url->getUrl('amasty_recurring/plan/index')
                ),
                'listens' => [
                    $globalSetting . ':value' => 'onChange'
                ],
                'imports' => [
                    'allowed' => AvailableSubscription::CUSTOM_SETTING,
                    'fields' => '${$.ns}.${$.ns}.subscription-settings',
                    '__disableTmpl' => ['fields' => false],
                ]
            ]
        );

        return $meta;
    }

    /**
     * @param array $meta
     * @return array
     */
    private function addDefaultValue(array $meta)
    {
        $meta = $this->arrayManager->merge(
            $this->arrayManager->findPath(
                ProductRecurringAttributesInterface::SUBSCRIPTION_ONLY,
                $meta,
                null,
                'children'
            ) . static::META_CONFIG_PATH,
            $meta,
            [
                'value' => Boolean::VALUE_NO
            ]
        );

        return $meta;
    }

    /**
     * @param array $data
     * @return array
     */
    public function modifyData(array $data)
    {
        return $data;
    }
}
