<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class ValidateDirectory implements DataPatchInterface
{
    /**
     * @var Filesystem
     */
    private $filesystem;

    public function __construct(Filesystem $filesystem)
    {
        $this->filesystem = $filesystem;
    }

    /**
     * @return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @return $this
     */
    public function apply()
    {
        try {
            $this->validateDirectory();
        } catch (\RuntimeException $e) {
            throw $e;
        } catch (\Exception $e) {
            null;
        }

        return $this;
    }

    /**
     * validate old directory existing
     * @throws \RuntimeException
     */
    private function validateDirectory()
    {
        $directory = $this->filesystem->getDirectoryRead(DirectoryList::APP);
        if ($directory->isExist('code/Amasty/RecurringPayments/Controller/Stripe/Index.php')) {
            $message = "WARNING: This update requires removing folder app/code/Amasty/RecurringPayments.\n"
                . "Remove this folder and unpack new version of package into app/code/Amasty/RecurringPayments.\n"
                . "Run `php bin/magento setup:upgrade` again";
            throw new \RuntimeException($message);
        }
    }
}
