<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Magento\Catalog\Api\Data\ProductAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class RemoveOldProductAttributes implements DataPatchInterface
{
    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    /**
     * @var ModuleDataSetupInterface
     */
    private $setup;

    public function __construct(EavSetupFactory $eavSetupFactory, ModuleDataSetupInterface $setup)
    {
        $this->eavSetupFactory = $eavSetupFactory;
        $this->setup = $setup;
    }

    /**
     * @return $this
     */
    public function apply()
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->setup]);

        $attributesToDelete = [
            'am_billing_cycle',
            'am_billing_frequency',
            'am_billing_frequency_unit',
            'am_enable_free_trials',
            'am_number_trial_days',
            'am_enable_charge_fee',
            'am_initial_fee_type',
            'am_initial_fee_amount',
            'am_enable_discounted_prices',
            'am_discount_type',
            'am_discount_amount',
            'am_discount_percent',
            'am_enable_limit_discount_cycle',
            'am_limit_discount_cycle',
        ];

        foreach ($attributesToDelete as $attributeCode) {
            $eavSetup->removeAttribute(
                ProductAttributeInterface::ENTITY_TYPE_CODE,
                $attributeCode
            );
        }

        return $this;
    }

    /**
     * @return string[]
     */
    public static function getDependencies()
    {
        return [CreateSubscriptionPlans::class];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }
}
