<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringPayments\Model\ResourceModel\Subscription as SubscriptionResource;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class FillCustomerEmailField implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @return $this
     */
    public function apply()
    {
        $setup = $this->moduleDataSetup;
        $connection = $setup->getConnection();
        $subscriptionTableName = $setup->getTable(SubscriptionResource::TABLE_NAME);
        $orderTableName = $setup->getTable('sales_order');

        $customerEmailField = SubscriptionInterface::CUSTOMER_EMAIL;
        $orderIdField = SubscriptionInterface::ORDER_ID;

        $select = $connection->select()
            ->from(
                false,
                [
                    $customerEmailField => new \Zend_Db_Expr('o.customer_email')
                ]
            )->join(
                ['o' => $orderTableName],
                'o.entity_id = ' . $orderIdField,
                []
            )->where($subscriptionTableName . '.' . $customerEmailField . ' = ""');

        $updateQuery = $connection->updateFromSelect(
            $select,
            $subscriptionTableName
        );

        $connection->query($updateQuery);

        return $this;
    }
}
