<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Amasty\RecurringPayments\Model\ResourceModel\Subscription as SubscriptionResource;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class FillBaseGrandTotalWithDiscount implements DataPatchInterface
{

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @return $this
     */
    public function apply()
    {
        $setup = $this->moduleDataSetup;
        
        $connection = $setup->getConnection();
        $subscriptionTableName = $setup->getTable(SubscriptionResource::TABLE_NAME);

        $field = SubscriptionInterface::BASE_GRAND_TOTAL_WITH_DISCOUNT;
        $grandTotalField = SubscriptionInterface::BASE_GRAND_TOTAL;
        $discountField = SubscriptionInterface::BASE_DISCOUNT_AMOUNT;

        $select = $connection->select()
            ->from(
                false,
                [
                    $field => new \Zend_Db_Expr("`{$grandTotalField}` - `{$discountField}`")
                ]
            )->where($field . ' = 0');

        $updateQuery = $connection->updateFromSelect(
            $select,
            $subscriptionTableName
        );

        $connection->query($updateQuery);
        
        return $this;
    }
}
