<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Amasty\Base\Helper\Deploy;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class DeployPub implements DataPatchInterface
{
    /**
     * @var Deploy
     */
    private $pubDeployer;

    public function __construct(Deploy $pubDeployer)
    {
        $this->pubDeployer = $pubDeployer;
    }

    /**
     * @return array
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }

    public function apply()
    {
        $this->pubDeployer->deployFolder(__DIR__.'/../../../pub');

        return $this;
    }
}
