<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Setup\Patch\Data;

use Amasty\RecurringPayments\Setup\Operation\CreatePlansAndAssign;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class CreateSubscriptionPlans implements DataPatchInterface
{
    /**
     * @var CreatePlansAndAssign
     */
    private $createPlansAndAssign;

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    public function __construct(CreatePlansAndAssign $createPlansAndAssign, ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->createPlansAndAssign = $createPlansAndAssign;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @return string[]
     */
    public static function getDependencies()
    {
        return [
            CreateProductAttributes::class
        ];
    }

    /**
     * @return array
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @return $this|CreateSubscriptionPlans
     */
    public function apply()
    {
        $this->createPlansAndAssign->execute($this->moduleDataSetup);

        return $this;
    }
}
