<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Plugin\Model\SalesRule;

use Amasty\RecurringPayments\Model\Discount\ItemDiscount;
use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\SalesRule\Model\ResourceModel\Rule\Collection;
use Magento\SalesRule\Model\Rule;
use Magento\SalesRule\Model\RulesApplier;

class RulesApplierPlugin
{
    /**
     * @var ItemDiscount
     */
    private $itemDiscount;

    public function __construct(
        ItemDiscount $itemDiscount
    ) {
        $this->itemDiscount = $itemDiscount;
    }

    /**
     * @param RulesApplier $subject
     * @param AbstractItem $item
     * @param Collection|Rule[] $rules
     * @param bool $skipValidation
     * @param $couponCode
     *
     * @return array
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeApplyRules(
        RulesApplier $subject,
        AbstractItem $item,
        $rules,
        bool $skipValidation,
        $couponCode
    ): array {
        $item = $this->itemDiscount->setDiscount($item);

        return [$item, $rules, $skipValidation, $couponCode];
    }
}
