<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Plugin\Model\SalesRule\Model\Validator;

use Amasty\RecurringPayments\Model\Discount\ItemDiscount;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Quote\Model\Quote\Item;
use Magento\SalesRule\Model\Validator;

class DiscountApplier
{
    /**
     * @var ItemDiscount
     */
    private $itemDiscount;

    public function __construct(
        ItemDiscount $itemDiscount
    ) {
        $this->itemDiscount = $itemDiscount;
    }

    /**
     * @param Validator $subject
     * @param  Item[] $items
     * @return Item[]
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterSortItemsByPriority(
        Validator $subject,
        array $items
    ): array {
        foreach ($items as $item) {
            $item = $this->itemDiscount->setDiscount($item);
        }

        return $items;
    }
}
