<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Plugin\Amazon\Gateway;

use Amasty\RecurringPayments\Model\Amazon\AmazonDisableValidator;
use Magento\Checkout\Model\Session;

class ConfigPlugin
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var AmazonDisableValidator
     */
    private $amazonDisableValidator;

    public function __construct(Session $session, AmazonDisableValidator $amazonDisableValidator)
    {
        $this->session = $session;
        $this->amazonDisableValidator = $amazonDisableValidator;
    }

    /**
     * @param \Amazon\Payment\Gateway\Config\Config $subject
     * @param bool $result
     *
     * @return bool
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterIsActive(\Amazon\Payment\Gateway\Config\Config $subject, bool $result): bool
    {
        $isAmazonActive = $result;
        $quote = $this->session->getQuote();
        if ($isAmazonActive && $this->amazonDisableValidator->needDisableAmazon($quote)) {
            $isAmazonActive = false;
        }

        return $isAmazonActive;
    }
}
