<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Plugin\Amazon;

use Amasty\RecurringPayments\Model\Amazon\AmazonDisableValidator;
use Amazon\Payment\Plugin\CheckoutProcessor;
use Magento\Checkout\Block\Checkout\LayoutProcessor;
use Magento\Checkout\Model\Session;

class CheckoutProcessorPlugin
{
    /**
     * @var Session
     */
    private $session;

    /**
     * @var string
     */
    private $paymentsListComponent;

    /**
     * @var AmazonDisableValidator
     */
    private $amazonDisableValidator;

    public function __construct(Session $session, AmazonDisableValidator $amazonDisableValidator)
    {
        $this->session = $session;
        $this->amazonDisableValidator = $amazonDisableValidator;
    }

    /**
     * @param CheckoutProcessor $subject
     * @param LayoutProcessor $processor
     * @param array $jsLayout
     * @return void
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeAfterProcess(CheckoutProcessor $subject, LayoutProcessor $processor, array $jsLayout): void
    {
        $this->paymentsListComponent = $jsLayout['components']['checkout']['children']['steps']['children']
            ['billing-step']['children']['payment']['children']['payments-list']['component'] ?? null;
    }

    /**
     * @param CheckoutProcessor $subject
     * @param array $jsLayout
     *
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterAfterProcess(CheckoutProcessor $subject, array $jsLayout): array
    {
        /** @var \Magento\Quote\Api\Data\CartInterface $quote */
        $quote = $this->session->getQuote();

        if ($this->amazonDisableValidator->needDisableAmazon($quote)) {
            $shippingConfig = &$jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']
            ['children']['shippingAddress'];
            $paymentConfig = &$jsLayout['components']['checkout']['children']['steps']['children']['billing-step']
            ['children']['payment'];

            if ($this->paymentsListComponent) {
                $paymentConfig['children']['payments-list']['component'] = $this->paymentsListComponent;
            }

            // @TODO problem place
            $shippingConfig['component'] = 'Magento_Checkout/js/view/shipping';
            $shippingConfig['children']['address-list']['component'] = 'Magento_Checkout/js/view/shipping-address/list';

            unset(
                $shippingConfig['children']['customer-email']['children']['amazon-button-region'],
                $shippingConfig['children']['before-form']['children']['amazon-widget-address'],
                $shippingConfig['children']['shipping-address-fieldset']['children']['inline-form-manipulator'],
                $paymentConfig['children']['renders']['children']['amazon_payment'],
                $paymentConfig['children']['beforeMethods']['children']['amazon-sandbox-simulator'],
                $paymentConfig['children']['payments-list']['children']['amazon_payment-form']
            );
        }

        return $jsLayout;
    }
}
