<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Observer\Model\Payment\Cart;

use Amasty\RecurringPayments\Api\FeeRepositoryInterface;
use Magento\Framework\Event\{Observer, ObserverInterface};

/**
 * Class CollectTotalsAndAmounts
 */
class CollectTotalsAndAmounts implements ObserverInterface
{
    /**
     * @var FeeRepositoryInterface
     */
    private $feeRepository;

    public function __construct(FeeRepositoryInterface $feeRepository)
    {
        $this->feeRepository = $feeRepository;
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        $cart = $observer->getData('cart');

        $id = $cart->getSalesModel()->getDataUsingMethod('entity_id')
            ?? $cart->getSalesModel()->getDataUsingMethod('quote_id');

        $fee = $this->feeRepository->getByQuoteId($id);

        if ($fee->getBaseAmount()) {
            $cart->addCustomItem(
                (string)__('Initial Subscription Fee'),
                1,
                $fee->getBaseAmount()
            );
        }
    }
}
