<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\Scheduler\Handler;

use Amasty\RecurringPayments\Api\Data\ScheduleInterface;
use Amasty\RecurringPayments\Api\Subscription\RepositoryInterface;
use Amasty\RecurringPayments\Model\Subscription\Operation\TrialWillEndOperation;

class TrialWillEnd extends AbstractScheduleHandler
{
    /**
     * @var TrialWillEndOperation
     */
    private $trialWillEndOperation;

    public function __construct(
        RepositoryInterface $subscriptionRepository,
        TrialWillEndOperation $trialWillEndOperation
    ) {
        parent::__construct($subscriptionRepository);
        $this->trialWillEndOperation = $trialWillEndOperation;
    }

    /**
     * @param ScheduleInterface $schedule
     */
    public function handle(ScheduleInterface $schedule)
    {
        $subscription = $this->getSubscription($schedule->getSubscriptionId());
        $this->assertSubscriptionActive($subscription);
        $this->trialWillEndOperation->execute($subscription);
    }
}
