<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\Scheduler\Handler;

use Amasty\RecurringPayments\Api\Data\ScheduleInterface;
use Amasty\RecurringPayments\Api\Subscription\RepositoryInterface;
use Amasty\RecurringPayments\Model\Subscription\Operation\SubscriptionCancelOperation;

class SubscriptionCancel extends AbstractScheduleHandler
{
    /**
     * @var SubscriptionCancelOperation
     */
    private $subscriptionCancelOperation;

    public function __construct(
        RepositoryInterface $subscriptionRepository,
        SubscriptionCancelOperation $subscriptionCancelOperation
    ) {
        parent::__construct($subscriptionRepository);
        $this->subscriptionCancelOperation = $subscriptionCancelOperation;
    }

    /**
     * @param ScheduleInterface $schedule
     */
    public function handle(ScheduleInterface $schedule)
    {
        $subscription = $this->getSubscription($schedule->getSubscriptionId());
        $this->assertSubscriptionActive($subscription);
        $this->subscriptionCancelOperation->execute($subscription);
    }
}
