<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\HandleOrder;

class HandlerPartsOrderedList
{
    public const BEFORE_ALL = '-';
    public const AFTER_ALL = '+';

    /**
     * @var HandlerPartInterface[]
     */
    private $handlerParts;

    public function __construct(array $handlerParts)
    {
        $this->handlerParts = $handlerParts;
    }

    public function addPart(
        HandlerPartInterface $handlerPart,
        string $key,
        string $modeOrAfterKey = self::AFTER_ALL
    ): void {
        $resultHandlers = [];

        if ($modeOrAfterKey === self::BEFORE_ALL) {
            $resultHandlers[$key] = $handlerPart;
        }

        foreach ($this->handlerParts as $currentKey => $currentHandlerPart) {
            $resultHandlers[$currentKey] = $currentHandlerPart;

            if ($currentKey === $modeOrAfterKey) {
                $resultHandlers[$key] = $handlerPart;
            }
        }

        if ($modeOrAfterKey === self::AFTER_ALL) {
            $resultHandlers[$key] = $handlerPart;
        }

        $this->handlerParts = $resultHandlers;
    }

    /**
     * @return HandlerPartInterface[]
     */
    public function getHandlerParts(): array
    {
        return $this->handlerParts;
    }
}
