<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\HandleOrder;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Magento\Framework\DataObject;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Sales\Api\Data\InvoiceInterface;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\TransactionInterface;

class HandleOrderContext extends DataObject
{
    /**
     * @var string|null
     */
    private $transactionId;

    /**
     * @var SubscriptionInterface|null
     */
    private $subscription;

    /**
     * @var CartInterface|null
     */
    private $quote;

    /**
     * @var OrderInterface|null
     */
    private $order;

    /**
     * @var InvoiceInterface|null
     */
    private $invoice;

    /**
     * @var TransactionInterface|null
     */
    private $transaction;

    /**
     * @var \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    private $recurringTransaction;

    /**
     * @return string|null
     */
    public function getTransactionId(): ?string
    {
        return $this->transactionId;
    }

    /**
     * @param string $transactionId
     */
    public function setTransactionId(string $transactionId): void
    {
        $this->transactionId = $transactionId;
    }

    /**
     * @return SubscriptionInterface|null
     */
    public function getSubscription(): ?SubscriptionInterface
    {
        return $this->subscription;
    }

    /**
     * @param SubscriptionInterface $subscription
     */
    public function setSubscription(SubscriptionInterface $subscription): void
    {
        $this->subscription = $subscription;
    }

    /**
     * @return CartInterface|null
     */
    public function getQuote(): ?CartInterface
    {
        return $this->quote;
    }

    /**
     * @param CartInterface $quote
     */
    public function setQuote(CartInterface $quote): void
    {
        $this->quote = $quote;
    }

    /**
     * @return OrderInterface|null
     */
    public function getOrder(): ?OrderInterface
    {
        return $this->order;
    }

    /**
     * @param OrderInterface $order
     */
    public function setOrder(OrderInterface $order): void
    {
        $this->order = $order;
    }

    /**
     * @return InvoiceInterface|null
     */
    public function getInvoice(): ?InvoiceInterface
    {
        return $this->invoice;
    }

    /**
     * @param InvoiceInterface $invoice
     */
    public function setInvoice(InvoiceInterface $invoice): void
    {
        $this->invoice = $invoice;
    }

    /**
     * @return TransactionInterface|null
     */
    public function getTransaction(): ?TransactionInterface
    {
        return $this->transaction;
    }

    /**
     * @param TransactionInterface $transaction
     */
    public function setTransaction(TransactionInterface $transaction): void
    {
        $this->transaction = $transaction;
    }

    /**
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function getRecurringTransaction(): \Amasty\RecurringPayments\Api\Data\TransactionInterface
    {
        return $this->recurringTransaction;
    }

    /**
     * @param \Amasty\RecurringPayments\Api\Data\TransactionInterface $recurringTransaction
     */
    public function setRecurringTransaction(
        \Amasty\RecurringPayments\Api\Data\TransactionInterface $recurringTransaction
    ): void {
        $this->recurringTransaction = $recurringTransaction;
    }
}
