<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\Create;

use Magento\Framework\ObjectManagerInterface;

class ProcessorPool
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var array
     */
    private $processors;

    public function __construct(ObjectManagerInterface $objectManager, array $processors = [])
    {
        $this->objectManager = $objectManager;
        $this->processors = $processors;
    }

    /**
     * @param string $name
     * @return CreateSubscriptionsProcessorInterface|null
     */
    public function get(string $name): ?CreateSubscriptionsProcessorInterface
    {
        $processorClass = $this->processors[$name] ?? null;

        if ($processorClass) {
            return $this->objectManager->get($processorClass);
        }

        return null;
    }
}
