<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\Create;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\Sales\Api\Data\OrderInterface;

class CreateSubscriptionsProcessor implements CreateSubscriptionsProcessorInterface
{
    /**
     * @var ProcessorPool
     */
    private $processorPool;

    public function __construct(ProcessorPool $processorPool)
    {
        $this->processorPool = $processorPool;
    }

    /**
     * @param OrderInterface $order
     * @param AbstractItem[] $items
     * @return SubscriptionInterface[]
     */
    public function process(OrderInterface $order, array $items): array
    {
        $method = $order->getPayment()->getMethod();
        $processor = $this->processorPool->get($method);
        $subscriptions = [];
        
        if ($processor) {
            $subscriptions = $processor->process($order, $items);
        }

        return $subscriptions;
    }
}
