<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Subscription\Create;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\Sales\Api\Data\OrderInterface;

interface CreateSubscriptionHandlerInterface
{
    /**
     * @param OrderInterface $order
     * @param AbstractItem $item
     * @param SubscriptionInterface $subscription
     */
    public function handle(
        OrderInterface $order,
        AbstractItem $item,
        SubscriptionInterface $subscription
    ): void;
}
