<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Product\Source;

class AvailableSubscription extends \Amasty\RecurringPayments\Model\AbstractArray
{
    public const NO = 'no';
    public const GLOBAL_SETTING = 'global_setting';
    public const CUSTOM_SETTING = 'custom_setting';

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        $options = [
            self::NO => __('No'),
            self::GLOBAL_SETTING => __('Yes, use global subscription settings'),
            self::CUSTOM_SETTING => __('Yes, use custom subscription settings'),
        ];

        return $options;
    }
}
