<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\DateTime;

class DateTimeComparer
{
    /**
     * @param string $dateA
     * @param string $dateB
     * @return bool
     */
    public function compareDates(string $dateA, string $dateB)
    {
        $onlyDateAObject = $this->getOnlyDate($dateA);
        $onlyDateBObject = $this->getOnlyDate($dateB);

        return $onlyDateAObject == $onlyDateBObject;
    }

    /**
     * @param string $date
     * @return \DateTime
     */
    private function getOnlyDate(string $date)
    {
        $dateObject = $this->getDateObject($date);

        return $this->getDateObject($dateObject->format('Y-m-d'));
    }

    /**
     * @param string $date
     * @return \DateTime
     */
    private function getDateObject(string $date)
    {
        return new \DateTime($date);
    }
}
