<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;
use Amasty\RecurringPayments\Model\Payment;

class SupportedPayments extends AbstractArray
{
    /**
     * @var Payment
     */
    private $paymentConfig;

    public function __construct(
        Payment $paymentConfig
    ) {
        $this->paymentConfig = $paymentConfig;
    }

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        return $this->paymentConfig->getConfigMethods();
    }
}
