<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

class StockActions extends AbstractArray
{
    public const NOTHING = 'nothing';
    public const PAUSE = 'pause';
    public const CANCEL = 'cancel';

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        $options = [
            self::NOTHING => __('Do Nothing'),
            self::PAUSE => __('Pause Subscription'),
            self::CANCEL => __('Cancel Subscription'),
        ];

        return $options;
    }
}
