<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

class Status extends AbstractArray
{
    public const FAILED = 0;
    public const SUCCESS = 1;
    public const ACTION_REQUIRED = 2;

    public function toArray(): array
    {
        return [
            self::FAILED          => __('Failed'),
            self::SUCCESS         => __('Success'),
            self::ACTION_REQUIRED => __('Additional Action Required')
        ];
    }
}
