<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

class PlanStatus extends AbstractArray
{
    public const SUSPENDED = 0;
    public const ACTIVE = 1;

    /**
     * @return array
     */
    public function toArray(): array
    {
        return [
            self::SUSPENDED => __('Suspended'),
            self::ACTIVE => __('Active'),
        ];
    }
}
