<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

class EnableDisable extends AbstractArray
{
    public const DISABLE = 'disable';
    public const ENABLE = 'enable';

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        $options = [
            self::DISABLE => __('Disable'),
            self::ENABLE => __('Enable'),
        ];

        return $options;
    }
}
