<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

/**
 * @deprecated since 1.6.0
 */
class BillingCycle extends AbstractArray
{
    public const CUSTOM = 'custom';
    public const ONCE_DAY = 'once_day';
    public const ONCE_WEEK = 'once_week';
    public const ONCE_MONTH = 'once_month';
    public const ONCE_YEAR = 'once_year';
    public const CUSTOMER_DECIDE = 'customer_decide';

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        $options = [
            self::CUSTOM => __('Custom'),
            self::ONCE_DAY => __('Once a day'),
            self::ONCE_WEEK => __('Once a week'),
            self::ONCE_MONTH => __('Once a month'),
            self::ONCE_YEAR => __('Once a year'),
            self::CUSTOMER_DECIDE => __('Let your customer decide'),
        ];

        return $options;
    }
}
