<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config\Source;

use Amasty\RecurringPayments\Model\AbstractArray;

class AmountType extends AbstractArray
{
    public const FIXED_AMOUNT = 'fixed_amount';
    public const PERCENT_AMOUNT = 'percent_product_price';

    /**
     * @inheritDoc
     */
    public function toArray(): array
    {
        $options = [
            self::FIXED_AMOUNT => __('Fixed Amount'),
            self::PERCENT_AMOUNT => __('Percent of Product Price'),
        ];

        return $options;
    }
}
