<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Config;

use Amasty\RecurringPayments\Api\Config\ValidatorInterface;

class ConfigurationValidator
{
    /**
     * @var ValidatorInterface[]
     */
    private $methodValidators;

    public function __construct(
        array $methodValidators = []
    ) {
        $this->methodValidators = $methodValidators;
    }

    /**
     * @param string $methodName
     * @return bool
     */
    public function isMethodConfiguredProperly(string $methodName): bool
    {
        foreach ($this->enumerateConfigurationIssues($methodName) as $issue) {
            return false; // Fail on first misconfiguration
        }

        return true;
    }

    public function getConfigurationIssues(string $methodName): array
    {
        return iterator_to_array($this->enumerateConfigurationIssues($methodName));
    }

    public function enumerateConfigurationIssues(string $methodName): \Generator
    {
        if (!isset($this->methodValidators[$methodName])) {
            yield __('Payment method adapter is not enabled');

            return;
        }

        foreach ($this->methodValidators[$methodName]->enumerateConfigurationIssues() as $issue) {
            yield $issue;
        }
    }
}
