<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Model\Amazon;

use Amasty\RecurringPayments\Model\QuoteValidate;
use Magento\Quote\Api\Data\CartInterface;

class AmazonDisableValidator
{
    /**
     * @var QuoteValidate
     */
    private $quoteValidate;

    public function __construct(QuoteValidate $quoteValidate)
    {
        $this->quoteValidate = $quoteValidate;
    }

    /**
     * @param CartInterface $quote
     * @return bool
     */
    public function needDisableAmazon(CartInterface $quote): bool
    {
        return $this->quoteValidate->validateQuote($quote);
    }
}
