<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Cron;

use Amasty\RecurringPayments\Model\Subscription\Scheduler\Handler;

class RunSchedule
{

    /**
     * @var Handler
     */
    private $schedulerHandler;

    public function __construct(Handler $schedulerHandler)
    {
        $this->schedulerHandler = $schedulerHandler;
    }

    /**
     * Run subscriptions by schedule
     *
     * @return void
     */
    public function execute()
    {
        $this->schedulerHandler->handle();
    }
}
