<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Controller\Adminhtml\Plan;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Forward;
use Magento\Framework\App\Action\HttpGetActionInterface;

class NewAction extends Action implements HttpGetActionInterface
{
    public const ADMIN_RESOURCE = 'Amasty_RecurringPayments::recurring_payments_subscription_plans';

    /**
     * @var Forward
     */
    private $resultForward;

    public function __construct(Context $context, Forward $resultForward)
    {
        parent::__construct($context);
        $this->resultForward = $resultForward;
    }

    /**
     * @return void
     */
    public function execute()
    {
        $this->resultForward->forward('edit');
    }
}
