<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Controller\Adminhtml\Plan;

use Amasty\RecurringPayments\Api\Data\SubscriptionPlanInterface;
use Amasty\RecurringPayments\Api\SubscriptionPlanRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\Model\View\Result\RedirectFactory;

class Delete extends \Magento\Backend\App\Action
{
    public const ADMIN_RESOURCE = 'Amasty_RecurringPayments::recurring_payments_subscription_plans';

    /**
     * @var SubscriptionPlanRepositoryInterface
     */
    private $repository;

    /**
     * @var RedirectFactory
     */
    private $redirectFactory;

    public function __construct(
        Action\Context $context,
        SubscriptionPlanRepositoryInterface $repository,
        RedirectFactory $redirectFactory
    ) {
        parent::__construct($context);
        $this->repository = $repository;
        $this->redirectFactory = $redirectFactory;
    }

    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $planId = $this->getRequest()->getParam(SubscriptionPlanInterface::PLAN_ID);
        if ($planId) {
            try {
                $this->repository->deleteById((int)$planId);
                $this->messageManager->addSuccessMessage(__('Subscription Plan has been deleted.'));
            } catch (\Magento\Framework\Exception\NoSuchEntityException $exception) {
                $this->messageManager->addErrorMessage(__('This Subscription Plan does not exist.'));
            }
        }

        return $this->redirectFactory->create()->setPath('*/*/');
    }
}
