<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class GlobalNotification extends Field
{
    /**
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $url = $this->getUrl('catalog/product/index');
        $notifyText = "If you've just installed 'Subscriptions & Recurring Payments'"
            . "extension or have never "
            . "configured your subscription products before,"
            . "please take into consideration that, by default, products are "
            . "unavailable for subscription and might be properly configured. "
            . "The most efficient way to turn your regular "
            . "products into subscription products is to configure "
            . "global subscription settings and apply it to all your "
            . "products in bulk by going to <a href='%1' target='_blank'>Catalog</a> "
            . "and executing 'Make Selected Products "
            . "Available via Subscription' action from the dropdown menu. "
            . "Contrary, you can manually review your products and "
            . "configure custom subscription settings for them individually (this will override global configuration)";

        return '<div class="message message-notice notice">' . __($notifyText, $url) . '</div>';
    }
}
