<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Subscription;

interface SubscriptionInfoInterface extends \JsonSerializable
{
    /**#@+
     * Constants defined for keys of array, makes typos less likely
     */
    public const SUBSCRIPTION = 'subscription';
    public const ADDRESS = 'address';
    public const ORDER_INCREMENT_ID = 'order_increment_id';
    public const ORDER_LINK = 'order_link';
    public const SUBSCRIPTION_NAME = 'subscription_name';
    public const START_DATE = 'start_date';
    public const QUANTITY = 'quantity';
    public const TRIAL_START_DATE = 'trial_start_date';
    public const TRIAL_END_DATE = 'trial_end_date';
    public const DELIVERY = 'delivery';
    public const LAST_BILLING = 'last_billing';
    public const LAST_BILLING_AMOUNT = 'last_billing_amount';
    public const NEXT_BILLING = 'next_billing';
    public const NEXT_BILLING_AMOUNT = 'next_billing_amount';
    public const STATUS = 'status';
    public const IS_ACTIVE = 'is_active';
    public const APPROVAL_LINK = 'approval_link';

    /**#@-
     * @param SubscriptionInterface $subscription
     * @return SubscriptionInfoInterface
     */
    public function setSubscription(SubscriptionInterface $subscription): self;

    public function getSubscription(): SubscriptionInterface;

    /**
     * @param AddressInterface $address
     * @return $this
     */
    public function setAddress(AddressInterface $address): self;

    /**
     * @param string $increment
     * @return $this
     */
    public function setOrderIncrementId(string $increment): self;

    /**
     * @param string $link
     * @return $this
     */
    public function setOrderLink(string $link): self;

    /**
     * @param string $name
     * @return $this
     */
    public function setSubscriptionName(string $name): self;

    /**
     * @param string $date
     * @return $this
     */
    public function setStartDate(string $date): self;

    /**
     * @return string
     */
    public function getStartDate(): string;

    /**
     * @param string $date
     * @return $this
     */
    public function setTrialStartDate(string $date): self;

    /**
     * @param string $date
     * @return $this
     */
    public function setTrialEndDate(string $date): self;

    /**
     * @param string $delivery
     * @return $this
     */
    public function setDelivery(string $delivery): self;

    /**
     * @param string $date
     * @return $this
     */
    public function setLastBilling(string $date): self;

    /**
     * @return string
     */
    public function getLastBilling(): string;

    /**
     * @param string $amount
     * @return $this
     */
    public function setLastBillingAmount(string $amount): self;

    /**
     * @param string $date
     * @return $this
     */
    public function setNextBilling(string $date): self;

    /**
     * @return string
     */
    public function getNextBilling(): string;

    /**
     * @param string $amount
     * @return $this
     */
    public function setNextBillingAmount(string $amount): self;

    /**
     * @param string $status
     * @return $this
     */
    public function setStatus(string $status): self;

    /**
     * @param string $link
     * @return $this
     */
    public function setApprovalLink(string $link): self;

    /**
     * @param bool $isActive
     * @return $this
     */
    public function setIsActive(bool $isActive): self;
}
