<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Generators;

use Magento\Sales\Api\Data\{InvoiceInterface, TransactionInterface, OrderInterface};

/**
 * Interface TransactionGeneratorInterface
 */
interface TransactionGeneratorInterface
{
    /**
     * @param OrderInterface $order
     * @param InvoiceInterface $invoice
     *
     * @return TransactionInterface
     */
    public function generate(OrderInterface $order, InvoiceInterface $invoice): TransactionInterface;
}
