<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Generators;

use Amasty\RecurringPayments\Api\Data\TransactionInterface;

interface RecurringTransactionGeneratorInterface
{
    /**
     * @param float $billingAmount
     * @param string $orderId
     * @param string $currency
     * @param string $transactionId
     * @param int $status
     * @param string $subscriptionId
     * @param string|null $billingDate
     * @param string|null $newOrderId
     * @return TransactionInterface
     */
    public function generate(
        float $billingAmount,
        string $orderId,
        string $currency,
        string $transactionId,
        int $status,
        string $subscriptionId,
        ?string $billingDate = null,
        ?string $newOrderId = null
    ): TransactionInterface;
}
