<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Generators;

use Amasty\RecurringPayments\Api\Subscription\SubscriptionInterface;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Quote\Api\Data\CartItemInterface;

/**
 * Interface QuoteGeneratorInterface
 */
interface QuoteGeneratorInterface
{
    /**
     * @param SubscriptionInterface $subscription
     * @param \Magento\Sales\Api\Data\OrderAddressInterface|null $shippingAddress
     * @param \Magento\Sales\Api\Data\OrderAddressInterface|null $billingAddress
     * @return CartInterface
     */
    public function generate(
        SubscriptionInterface $subscription,
        ?\Magento\Sales\Api\Data\OrderAddressInterface $shippingAddress = null,
        ?\Magento\Sales\Api\Data\OrderAddressInterface $billingAddress = null
    ): CartInterface;

    /**
     * @param CartItemInterface $item
     * @return CartInterface
     */
    public function generateFromItem(CartItemInterface $item): CartInterface;
}
