<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Generators;

use Magento\Quote\Api\Data\CartInterface;
use Magento\Sales\Api\Data\OrderInterface;

/**
 * Interface OrderGeneratorInterface
 */
interface OrderGeneratorInterface
{
    /**
     * @param CartInterface $quote
     * @param string $paymentMethod
     * @param string $currency
     *
     * @return OrderInterface
     */
    public function generate(
        CartInterface $quote,
        string $paymentMethod,
        string $currency
    ): OrderInterface;
}
