<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Generators;

use Magento\Sales\Api\Data\{InvoiceInterface, OrderInterface};

/**
 * Interface InvoiceGeneratorInterface
 */
interface InvoiceGeneratorInterface
{
    /**
     * @param OrderInterface $order
     * @param string|null $transactionId
     *
     * @return InvoiceInterface
     */
    public function generate(OrderInterface $order, string $transactionId = null): InvoiceInterface;
}
