<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Data;

/**
 * Interface TransactionInterface
 */
interface TransactionInterface
{
    public const STATUS_FAIL = 0;
    public const STATUS_SUCCESS = 1;

    public const ENTITY_ID = 'entity_id';
    public const TRANSACTION_ID = 'transaction_id';
    public const ORDER_ID = 'order_id';
    public const BILLING_AMOUNT = 'billing_amount';
    public const BILLING_DATE = 'billing_date';
    public const STATUS = 'status';
    public const CURRENCY_CODE = 'billing_currency_code';
    public const SUBSCRIPTION_ID = 'subscription_id';
    public const NEW_ORDER_ID = 'new_order_id';

    /**
     * @return int
     */
    public function getEntityId();

    /**
     * @param int $entityId
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setEntityId($entityId);

    /**
     * @return string
     */
    public function getTransactionId();

    /**
     * @param string $transactionId
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setTransactionId($transactionId);

    /**
     * @return string|null
     */
    public function getOrderId();

    /**
     * @param string|null $orderId
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setOrderId($orderId);

    /**
     * @return float
     */
    public function getBillingAmount();

    /**
     * @param float $billingAmount
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setBillingAmount($billingAmount);

    /**
     * @return string
     */
    public function getBillingDate();

    /**
     * @param string $billingDate
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setBillingDate($billingDate);

    /**
     * @return int
     */
    public function getStatus();

    /**
     * @param int $status
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setStatus($status);

    /**
     * @return string
     */
    public function getBillingCurrencyCode();

    /**
     * @param string $currencyCode
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setBillingCurrencyCode($currencyCode);

    /**
     * @return string
     */
    public function getSubscriptionId();

    /**
     * @param string $subscriptionId
     *
     * @return \Amasty\RecurringPayments\Api\Data\TransactionInterface
     */
    public function setSubscriptionId($subscriptionId);

    /**
     * @return string
     */
    public function getNewOrderId(): string;

    /**
     * @param string $newOrderId
     * @return TransactionInterface
     */
    public function setNewOrderId(string $newOrderId): TransactionInterface;
}
