<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Data;

/**
 * Interface FeeInterface
 */
interface FeeInterface
{
    /**#@+
     * Constants defined for keys of data array
     */
    public const ENTITY_ID = 'entity_id';
    public const QUOTE_ID = 'quote_id';
    public const AMOUNT = 'amount';
    public const BASE_AMOUNT = 'base_amount';
    /**#@-*/

    /**
     * @return int|null
     */
    public function getEntityId();

    /**
     * @param int|null $entityId
     *
     * @return FeeInterface
     */
    public function setEntityId($entityId): FeeInterface;

    /**
     * @return int
     */
    public function getQuoteId(): int;

    /**
     * @param int $quoteId
     *
     * @return FeeInterface
     */
    public function setQuoteId(int $quoteId): FeeInterface;

    /**
     * @return float
     */
    public function getAmount(): float;

    /**
     * @param float $amount
     *
     * @return FeeInterface
     */
    public function setAmount(float $amount): FeeInterface;

    /**
     * @return float
     */
    public function getBaseAmount(): float;

    /**
     * @param float $baseAmount
     *
     * @return FeeInterface
     */
    public function setBaseAmount(float $baseAmount): FeeInterface;
}
