<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Data;

interface EstimationItemInterface
{
    public const VALUE = 'value';
    public const ITEM_ID = 'item_id';

    /**
     * @return float
     */
    public function getValue(): float;

    /**
     * @param float $value
     * @return void
     */
    public function setValue(float $value): void;

    /**
     * @return int
     */
    public function getItemId(): int;

    /**
     * @param int $itemId
     * @return void
     */
    public function setItemId(int $itemId): void;
}
