<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Subscriptions & Recurring Payments for Magento 2 (System)
 */

namespace Amasty\RecurringPayments\Api\Data;

/**
 * @deprecated use SubscriptionInterface
 */
interface DiscountInterface
{
    public const ENTITY_ID = 'entity_id';
    public const SUBSCRIPTION_ID = 'subscription_id';
    public const DISCOUNT_USAGE = 'discount_usage';
    public const AVAILABLE_DISCOUNT_USAGE = 'available_discount_usage';

    /**
     * @return int
     */
    public function getEntityId();

    /**
     * @param int $entityId
     *
     * @return \Amasty\RecurringPayments\Api\Data\DiscountInterface
     */
    public function setEntityId($entityId);

    /**
     * @return string
     */
    public function getSubscriptionId();

    /**
     * @param string $subscriptionId
     *
     * @return \Amasty\RecurringPayments\Api\Data\DiscountInterface
     */
    public function setSubscriptionId($subscriptionId);

    /**
     * @return int
     */
    public function getDiscountUsage();

    /**
     * @param int $discountUsage
     *
     * @return \Amasty\RecurringPayments\Api\Data\DiscountInterface
     */
    public function setDiscountUsage($discountUsage);

    /**
     * @return int|null
     */
    public function getAvailableDiscountUsage();

    /**
     * @param int|null $availableDiscountUsage
     *
     * @return \Amasty\RecurringPayments\Api\Data\DiscountInterface
     */
    public function setAvailableDiscountUsage($availableDiscountUsage);
}
