<?php

namespace Amasty\Quickview\Helper;

use Magento\Store\Model\ScopeInterface;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @param $path
     *
     * @return mixed
     */
    public function getModuleConfig($path)
    {
        return $this->scopeConfig->getValue(
            'amasty_quickview/' . $path,
            ScopeInterface::SCOPE_STORE
        );
    }

    /**
     * @param $string
     * @param $data
     *
     * @return string
     */
    public function getUrl($string, $data)
    {
        return $this->_getUrl($string, $data);
    }

    /**
     * @return bool
     */
    public function isRedirectToCart()
    {
        return (bool)$this->scopeConfig->getValue(
            'checkout/cart/redirect_to_cart',
            ScopeInterface::SCOPE_STORE
        );
    }
}
