<?php

namespace Amasty\Quickview\Block;

class Page extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Amasty\Quickview\Helper\Data
     */
    private $helper;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Amasty\Quickview\Helper\Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->helper = $helper;
        $this->setTemplate('Amasty_Quickview::page.phtml');
    }

    /**
     * @return bool
     */
    public function closePopup()
    {
        return (bool)$this->helper->getModuleConfig('general/close_after_add');
    }

    /**
     * @return bool
     */
    public function redirectToCartAfterAdd()
    {
        return $this->helper->isRedirectToCart();
    }

    /**
     * @return string
     */
    public function getCartUrl()
    {
        return $this->getUrl('checkout/cart', ['_secure' => true]);
    }

    /**
     * @return string
     */
    public function getFormSelector()
    {
        return $this->helper->getModuleConfig('selectors/productFormSelector');
    }
}
