<?php

namespace Amasty\Quickview\Block;

use Magento\Framework\App\ActionInterface;

class Config extends \Magento\Framework\View\Element\Template
{
    public const LINK_TEMPLATE = '<img class="am-quickview-icon" src="%s"/>%s';

    /**
     * @var \Amasty\Quickview\Helper\Data
     */
    private $helper;

    /**
     * @var \Magento\Framework\Json\EncoderInterface
     */
    private $jsonEncoder;

    /**
     * @var \Magento\Framework\Url\EncoderInterface
     */
    private $urlEncoder;

    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Amasty\Quickview\Helper\Data $helper,
        \Magento\Framework\Json\EncoderInterface $jsonEncoder,
        \Magento\Framework\Url\EncoderInterface $urlEncoder,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->helper = $helper;
        $this->jsonEncoder = $jsonEncoder;
        $this->urlEncoder = $urlEncoder;
        $this->setTemplate('Amasty_Quickview::config.phtml');
    }

    /**
     * @return bool
     */
    public function isLoadFancybox()
    {
        return (bool) $this->helper->getModuleConfig('general/load_fancybox');
    }

    /**
     * @return string
     */
    public function javascriptParams()
    {
        $additional = ['amasty_quickview' => 1];
        $addUrlKey = ActionInterface::PARAM_NAME_URL_ENCODED;
        $addUrlValue = $this->_urlBuilder->getUrl('*/*/*', ['_use_rewrite' => true, '_current' => true]);
        $additional[$addUrlKey] = $this->urlEncoder->encode($addUrlValue);

        $params = [
            'url'  =>  $this->helper->getUrl('catalog/product/view', $additional),
            'text' =>  $this->getViewHtml(),
            'css'  =>  $this->helper->getModuleConfig('general/custom_css_styles'),
            'selectors' => $this->getSelectors()
        ];

        return $this->jsonEncoder->encode($params);
    }

    /**
     * @return string
     */
    private function getViewHtml()
    {
        return sprintf(
            self::LINK_TEMPLATE,
            $this->getIconImage(),
            $this->getViewText()
        );
    }

    /**
     * @return string
     */
    private function getViewText()
    {
        return $this->escapeHtml($this->helper->getModuleConfig('general/view_text'));
    }

    /**
     * @return string
     */
    private function getIconImage()
    {
        return $this->getViewFileUrl('Amasty_Quickview::images/len.png');
    }

    /**
     * @return array
     */
    private function getSelectors()
    {
        return [
            'productContainer' => $this->helper->getModuleConfig('selectors/productContainer'),
            'productImage' => $this->helper->getModuleConfig('selectors/productImage'),
            'productImageContainer' => $this->helper->getModuleConfig('selectors/productImageContainer')
        ];
    }

    /**
     * @return string
     */
    public function getProductItemSelector()
    {
        return $this->helper->getModuleConfig('selectors/productItem');
    }
}
