<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Product Option Templates GraphQL for Magento 2 (System)
 */

namespace Amasty\ProtGraphQl\Model;

use Magento\Framework\GraphQl\Query\Resolver\TypeResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\Entity\MapperInterface;

class CustomizableOptionTypeResolver implements TypeResolverInterface
{
    public const ENTITY_TYPE = 'amprot_customizable_options';

    /**
     * @var MapperInterface
     */
    private $mapper;

    /**
     * @param MapperInterface $mapper
     */
    public function __construct(MapperInterface $mapper)
    {
        $this->mapper = $mapper;
    }

    /**
     * {@inheritDoc}
     */
    public function resolveType(array $data) : string
    {
        $map = $this->mapper->getMappedTypes(self::ENTITY_TYPE);
        if (isset($map[$data['type']])) {
            return $map[$data['type']];
        }

        return '';
    }
}
