define([
    'underscore',
    'Magento_Ui/js/form/element/single-checkbox'
], function (_, singleCheckbox) {
    return singleCheckbox.extend({
        initialize: function () {
            this._super();

            this.dependencyChanged(
                this.source.get(this.dataScope + '.dependency')
            );

            return this;
        },

        /**
         * Disable or enable required checkbox for custom option depend on count corresponding DEPENDENCY
         * @param dependency
         */
        dependencyChanged: function (dependency) {
            this.disabled(dependency && dependency.length);
        }
    });
});
