<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Product Option Templates for Magento 2
 */

namespace Amasty\Prot\Setup\Patch\Schema;

use Amasty\Prot\Api\Data\ScheduleInterface;
use Amasty\Prot\Api\Data\TemplateOptionInterface;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Setup\Patch\SchemaPatchInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class AddForeignKey implements SchemaPatchInterface
{
    /**
     * @var SchemaSetupInterface
     */
    private $schemaSetup;

    /**
     * @var MetadataPool
     */
    private $metadataPool;

    public function __construct(
        SchemaSetupInterface $schemaSetup,
        MetadataPool $metadataPool
    ) {
        $this->schemaSetup = $schemaSetup;
        $this->metadataPool = $metadataPool;
    }

    public function apply(): self
    {
        $productMetadata = $this->metadataPool->getMetadata(ProductInterface::class);
        $this->schemaSetup->startSetup();
        $connection = $this->schemaSetup->getConnection();

        $connection->addForeignKey(
            $connection->getForeignKeyName(
                ScheduleInterface::MAIN_TABLE,
                ScheduleInterface::PRODUCT_ID,
                $this->schemaSetup->getTable('catalog_product_entity'),
                TemplateOptionInterface::OPTION_ID
            ),
            $this->schemaSetup->getTable(ScheduleInterface::MAIN_TABLE),
            ScheduleInterface::PRODUCT_ID,
            $this->schemaSetup->getTable('catalog_product_entity'),
            $productMetadata->getLinkField(),
            \Magento\Framework\DB\Ddl\Table::ACTION_CASCADE
        );

        $this->schemaSetup->endSetup();

        return $this;
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }
}
